#include <Ultrasonic_Sensor.h>                  //Βιβλιοθήκη

const int trigPin = 3;                          //Δήλωση της 1ης θύρας του αισθητήρα υπερήχων
const int echoPin = 4;                          //Δήλωση της 2ης θύρας του αισθητήρα υπερήχων

float t2;                                        // Δήλωση της μεταβλητής t2 (σε s) για τη μετάδοση του υπέρηχου από τον αισθητήρα έως το εμπόδιο και πίσω στον αισθητήρα

Ultrasonic_Sensor ultrasonic(trigPin, echoPin); // Έναρξη του αισθητήρα υπερήχων

void setup() 
{
  Serial.begin(9600);                           // Έναρξη της Σειριακής
}

void loop() 
{
  ultrasonic.sendTriggerPulse();                // Αποστολή παλμού υπερήχου στο εμπόδιο
  
  long duration = ultrasonic.readEcho();        // Χρονικό διάστημα σε μs από την αποστολή του υπερήχου στο εμπόδιο έως την επιστροφή του υπερήχου στον αισθητήρα

  t2 = duration / 1000000.0;                    // Χρονικό διάστημα σε s για τη μετάδοση του υπερήχου από τον αισθητήρα έως το εμπόδιο και πίσω στον αισθητήτα

  Serial.print("Δt = ");
  Serial.print(t2, 6);                          // Εκτυπώνει το Χρονικό διάστημα σε s με ακρίβεια 6 δεκαδικών
  Serial.println(" s");

  delay(1000);                                  // Καθυστέρηση για να διαβάσουμε την τιμή
}
